/*
 * Copyright European Commission's
 * Taxation and Customs Union Directorate-General (DG TAXUD).
 */
package eu.europa.ec.taxud.cesop.domain;

/**
 * Enum for Doc Types.
 */
public enum DocTypeEnum {

    /**
     * Cesop 1 doc type enum.
     */
    CESOP1("CESOP1"),
    /**
     * Cesop 2 doc type enum.
     */
    CESOP2("CESOP2"),
    /**
     * Cesop 3 doc type enum.
     */
    CESOP3("CESOP3");

    private final String code;

    DocTypeEnum(final String code) {
        this.code = code;
    }

    /**
     * Gets code.
     *
     * @return the code
     */
    public String getCode() {
        return this.code;
    }

    /**
     * Find a {@link DocTypeEnum} by its code.
     *
     * @param code the code
     * @return the DocTypeEnum
     * @throws IllegalArgumentException if there is no value for the code
     */
    public static DocTypeEnum findByCode(final String code) {
        for (final DocTypeEnum value : values()) {
            if (value.getCode().equals(code)) {
                return value;
            }
        }
        throw new IllegalArgumentException("No DocTypeEnum found for code: " + code);
    }
}
